#include <conio.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

/*
 *  It would look much cleaner if I'd used, say, 360x240 picture "waved" to
 *  320x200 buffer. For now I have to expand 320x200 one by zeros.
 */
#define XGAP 0
#define YGAP 30

char picbuf[64000], pic[(320 + XGAP) * (200 + YGAP)], tab[64000], sintab[256];
int  frame, multab[320], mousex, mousey;

#define PI 3.141592

extern void setVideoMode(short mode);
#pragma aux setVideoMode = \
  " int 10h " \
  parm [ax] \
  modify [eax];

extern void getMouse();
#pragma aux getMouse = \
  " sub ecx,ecx " \
  " sub edx,edx " \
  " mov ax,0003h " \
  " int 33h " \
  " mov mousex,ecx " \
  " mov mousey,edx " \
  modify [eax ebx ecx edx];

void fload(char *name, int size, void *dest) {
  FILE *f;

  if ((f = fopen(name, "rb")) == NULL) {
    printf("error: unable to open %s\n", name);
    exit(1);
  }
  if (fread(dest, 1, size, f) != size) {
    printf("error: unable to read %s\n", name);
    exit(1);
  }
  fclose(f);
}

void waitRetrace() {
  while ((inp(0x3DA) & 0x08) != 0);
  while ((inp(0x3DA) & 0x08) == 0);
}

void drawWave(int mx, int my) {
  int  x, y, px, py;
  char *dst = (char*)&tab;

  for (y = 0; y < 200; y++) {
    px = (-(mx >> 2));
    py = (y - my) * (y - my);
    px <<= 1;
    for (x = 0; x < 320; x++) {
      px++;
      py += px;
      *dst++ = sintab[(frame + (py >> 5)) & 0xFF] >> 2;
    }
  }
}

void drawPic(char *dst, char *src, char *tbl) {
  int x, y;

  tbl += 321;
  dst += 321;
  for (y = 1; y < 199; y++) {
    for (x = 1; x < 319; x++) {
      *dst++ = src[multab[(y + *(tbl - 320) - *(tbl + 320))]
	+ x + *(tbl + 1) - *(tbl - 1)];
      tbl++;
    }
    tbl += 2;
    dst += 2;
  }
}

void main() {
  int i, f, t;
  char pal[0x300];

  fload("pic.pal", 0x300, &pal);
  fload("pic.raw", 0xFA00, &picbuf);

  memset(pic, 0, sizeof(pic));
  for (i = 0; i < 200; i++) memcpy(&pic[i * (320 + XGAP)], &picbuf[i * 320], 320);
  for (i = 0; i < 256; i++) sintab[i] = (char)(cos(2 * PI * i / 256) * 127 + 128);
  for (i = 0; i < 320; i++) multab[i] = i * (320 + XGAP);

  frame = 0;
  setVideoMode(0x13);
  outp(0x3C8, 0x00);
  for (i = 0; i < 0x300; i++) outp(0x3C9, pal[i]);

  t = clock();
  f = 0;
  while (!kbhit()) {
    getMouse();
    drawWave(mousex, mousey);
    //waitRetrace();
    drawPic((char*)0xA0000L, (char*)&pic, (char*)&tab);
    frame -= 9;
    f++;
  }
  t = clock() - t;

  setVideoMode(0x03);
  printf(
    "- water effect - coded by shodan, 1998 - " \
    "e-mail: shodan@chat.ru -\n" \
    "  frames:   %d\n" \
    "  seconds:  %d.%02d\n" \
    "  fps:      %d.%02d\n",
    f, t / 100, t % 100,
    100 * f / t, 10000 * f / t - 100 * (100 * f / t));
}