;--==//>> MainstreaM Scroller #1 (v.1.0.0) by MiCRO^[[{TaS/NME} <<\\==--
;--==//>> ------------------------------------------------ <<\\==--
;--==//>> This will make my smallest, tightest, fastest,   <<\\==--
;--==//>> k-rad-n-est scroller, yet...                     <<\\==--

.286                                    ;allow 80286 code
.model small                            ;small memory model (.EXE)
.stack 256                              ;256-byte stack segment

VGA_SEG EQU     0A000h                  ;A000h=VGA Graphics Video Memory

.data                                   ;BEGIN data segment

;definition of the "DV8"... each number is a color out of 256 colors...
;NOTE: color #'s 0 & 1 will not be rotated (color 0 = 0,0,0 = black)

;4x16=64 x16=1024                                               |                                               |                                               |                                               |
;                           |           |           |           |           |           |           |           |           |           |           |           |           |           |           |           |
let_A   db        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
        db        0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,14,15,16,17, 0, 0, 0,20,21, 0,22,23,24, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0
        db        0, 1,13,13,13,13,13,13,13,13, 1, 0, 0, 0, 0, 0,14,15,16,17,18, 0, 0,20,21, 0,22,23,24,25, 0, 0, 0, 0, 0, 1, 0, 1, 1,55,56, 1,56,55, 1, 1, 0, 1, 0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0
        db        0, 1,12,12,12,12,12,12,12,12,12, 1, 0, 0, 0, 0, 0, 0, 0, 0,18,19, 0, 0, 0, 0, 0, 0, 0,25,26, 0, 0, 0, 0, 0, 0, 1, 1,55,56, 1,56,55, 1, 1, 0, 0, 0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 0, 0, 0, 0
        db        0, 1,11,11,11,11,11,11,11,11,11,11, 1, 0, 0, 0,14,15, 0,17,18,19, 0,20,21, 0,22,23, 0, 0,26,27, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 0, 0, 0
        db        0, 1, 1, 1, 1, 1, 1, 1, 1, 1,10,10,10, 1, 0, 0,14,15, 0,17,18,19, 0,20,21, 0,22,23, 0, 0,26,27, 0, 0, 0, 0, 0, 0, 1, 1,57, 1,57, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 5, 5, 1, 0, 0
        db        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 9, 9, 9, 1, 0,14,15, 0, 0,18,19, 0,20,21, 0,22,23, 0, 0,26,27, 0, 0, 0, 1, 1, 1, 0, 1,57, 1,57, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 6, 6, 6, 1, 0
        db        0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 8, 8, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 7, 7, 1, 0
        db        0, 1, 7, 7, 1, 0, 1, 1, 1, 1, 0, 1, 7, 7, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 8, 8, 1, 0, 1, 1, 1, 1, 0, 1, 8, 8, 1, 0
        db        0, 1, 6, 6, 1, 0, 1, 6, 6, 1, 0, 1, 6, 6, 1, 0, 0,40,39,38,37,36, 0,35,34,33,32,31, 0,30,29,28,27, 0, 0, 0,24,23,22,21,20, 0,19,18,17,16, 0, 0, 0, 1, 9, 9, 1, 0, 1, 9, 9, 1, 0, 1, 9, 9, 1, 0
        db        0, 1, 5, 5, 1, 0, 1, 5, 5, 1, 0, 1, 5, 5, 1, 0,41,40,39,38,37,36, 0,35,34,33,32,31, 0,30,29,28,27,26,25, 0,24,23,22,21,20, 0,19,18,17,16,15, 0, 0, 1,10,10, 1, 0, 1,10,10, 1, 0, 1,10,10, 1, 0
        db        0, 1, 4, 4, 1, 0, 1, 1, 1, 1, 0, 1, 4, 4, 1, 0,41,40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,26,25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,15,14, 0, 1,11,11, 1, 0, 1, 1, 1, 1, 0, 1,11,11, 1, 0
        db        0, 1, 3, 3, 1, 0, 0, 0, 0, 0, 0, 1, 3, 3, 1, 0, 0, 0, 0, 0,37,36, 0, 0,34,33, 0, 0, 0,30,29, 0,27,26, 0, 0,24,23, 0,21,20, 0,19,18, 0,16,15,14, 0, 1,12,12, 1, 0, 0, 0, 0, 0, 0, 1,12,12, 1, 0
        db        0, 1, 2, 2, 1, 0, 0, 0, 0, 0, 0, 1, 2, 2, 1, 0,41,40,39,38,37,36, 0, 0,34,33,32, 0, 0,30,29, 0,27,26, 0, 0,24,23, 0, 0, 0, 0,19,18, 0,16,15,14, 0, 1,13,13, 1, 0, 0, 0, 0, 0, 0, 1,13,13, 1, 0
        db        0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0,41,40,39,38,37, 0, 0, 0, 0,33,32, 0, 0,30,29, 0, 0,26,25, 0,24,23,22,21,20, 0,19,18, 0, 0,15,14, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0
        db        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

;length and width of "DV8" defined
a_width         db      64
a_length        db      16

;current x & y positions, beginning at (0,0)
x_pos           dw      128
y_pos           dw      92
x_pos2          dw      128
y_pos2          dw      92
x_pos3          dw      128
y_pos3          dw      92
x_pos4          dw      128
y_pos4          dw      92

;begin in direction 1, where:
;  direction 1 = down, right
;  direction 2 = up, right
;  direction 3 = up, left
;  direction 4 = down, left
direction       db      1
directionb      db      2
directionc      db      3
directiond      db      4

;used for rotation of palette
temp            db      3 DUP (?)
pal             db      768 DUP (?)

credit          db      'MainstreaM Scroller #1 (ver.1.0.0) By MiCRO^[[TaS/NM]',13,10
                db      'MainstreaM  [713] 647-0303  SysoP:Vermillion',13,10
                db      'TragiK aNSi SpinnerZ = FREE ART!!',13,10
                db      '(Look 4 the source in TaSPaK3!)',13,10,'$'

.code                                   ;BEGIN code segment

;clear the screen, set mode to 13h (320x200x256 VGA Graphics Mode)
        mov     ax,0013h                ;ROM-BIOS Service 00h (set mode) (al=13)
        int     10h                     ;perform interrupt (video services)

;copy pre-defined values for palette
        mov     cx,768                  ;256 colors * 3 bytes/color (r,g, & b)
        mov     ax,@code                ;
        mov     ds,ax                   ;
        mov     si,offset palarr        ;copy from palarr in CS
        mov     ax,@data                ;
        mov     es,ax                   ;
        mov     di,offset pal           ;copy to pal in DS
        rep     movsb                   ;copy the palette bytes...

        mov     si, offset pal          ;address our variable palette
        call    setpal                  ;set the palette using pal

        mov     ax,@data                ;the letter 'A' is in DS
        mov     ds,ax                   ;

        mov     ax,VGA_SEG              ;address the video memory
        mov     es,ax                   ;assign it to ES (extra seg)

        mov     si,0                    ;beginning of letter data
        mov     di,92*320+128;0                    ;beginning of video memory

;wait for any key (loop until keypressed)
keywait:
        mov     dx,3DAh
holdon:
        in      al,dx
        test    al,08h
        jz      holdon
retrace:
        in      al,dx
        test    al,08h
        jz      retrace

;display the cyber-letter 'A'
nextpixel:
        movsb
        dec     [a_width]               ;next byte in line
        jnz     nextpixel               ;have we drawn a line?
nextline:
        mov     [a_width],64            ;reset count for next line
        add     di,320-64               ;adjust video memory pointer
        dec     [a_length]              ;next line in letter
        jnz     nextpixel               ;have we drawn the letter?

        mov     si,0                    ;reset to start of letter A
        mov     ax,[y_pos2]             ;linear location = 320*y_pos + x_pos
        mov     bx,320
        mul     bx
        add     ax,[x_pos2]
        mov     di,ax
        mov     [a_length],16
nextpixel2:
        movsb
        dec     [a_width]              ;next byte in line
        jnz     nextpixel2              ;have we drawn a line?
nextline2:
        mov     [a_width],64           ;reset count for next line
        add     di,320-64               ;adjust video memory pointer
        dec     [a_length]             ;next line in letter
        jnz     nextpixel2              ;have we drawn the letter?

        mov     si,0                    ;reset to start of letter A
        mov     ax,[y_pos3]             ;linear location = 320*y_pos + x_pos
        mov     bx,320
        mul     bx
        add     ax,[x_pos3]
        mov     di,ax
        mov     [a_length],16

nextpixel3:
        movsb
        dec     [a_width]              ;next byte in line
        jnz     nextpixel3              ;have we drawn a line?
nextline3:
        mov     [a_width],64           ;reset count for next line
        add     di,320-64               ;adjust video memory pointer
        dec     [a_length]             ;next line in letter
        jnz     nextpixel3              ;have we drawn the letter?


        mov     si,0                    ;reset to start of letter A
        mov     ax,[y_pos4]             ;linear location = 320*y_pos + x_pos
        mov     bx,320
        mul     bx
        add     ax,[x_pos4]
        mov     di,ax
        mov     [a_length],16

nextpixel4:
        movsb
        dec     [a_width]              ;next byte in line
        jnz     nextpixel4              ;have we drawn a line?
nextline4:
        mov     [a_width],64           ;reset count for next line
        add     di,320-64               ;adjust video memory pointer
        dec     [a_length]             ;next line in letter
        jnz     nextpixel4              ;have we drawn the letter?
;==========================================================================
;determine current direction and jump to appropriate section
        cmp     [direction],1
        je      j_d1;direction1
        cmp     [direction],2
        je      j_d2;direction2
        cmp     [direction],3
        je      j_d3;direction3
        jmp     direction4              ;none of these?  then must be 4

j_d1:                                  ; fuck.... too far 2 jump conditionally
        jmp     direction1
j_d2:
        jmp     direction2
j_d3:
        jmp     direction3
;------------------------------------------------------------------------
check_direction2:
        cmp     [directionb],1
        je      j_d1b;direction1b
        cmp     [directionb],2
        je      j_d2b;direction2b
        cmp     [directionb],3
        je      j_d3b;direction3b
        jmp     direction4b             ;none of these?  then must be 4

j_d1b:                                  ; fuck.... too far 2 jump conditionally
        jmp     direction1b
j_d2b:
        jmp     direction2b
j_d3b:
        jmp     direction3b
;-------------------------------------------------------------------------
check_direction3:
        cmp     [directionc],1
        je      j_d1c;direction1c
        cmp     [directionc],2
        je      j_d2c;direction2c
        cmp     [directionc],3
        je      j_d3c;direction3c
        jmp     direction4c             ;none of these?  then must be 4

j_d1c:                                  ; fuck.... too far 2 jump conditionally
        jmp     direction1c
j_d2c:
        jmp     direction2c
j_d3c:
        jmp     direction3c
;-------------------------------------------------------------------------
check_direction4:
        cmp     [directiond],1
        je      j_d1d;direction1c
        cmp     [directiond],2
        je      j_d2d;direction2c
        cmp     [directiond],3
        je      j_d3d;direction3c
        jmp     direction4d             ;none of these?  then must be 4

j_d1d:                                  ; fuck.... too far 2 jump conditionally
        jmp     direction1d
j_d2d:
        jmp     direction2d
j_d3d:
        jmp     direction3d
;===========================================================================

;the following is neccesary because for every direction, there are two
;different boundries, and therefore two different reactions (new directions)
direction1:
        inc     [x_pos]                 ;move down one
        inc     [y_pos]                 ;move right one
        cmp     [x_pos],320-64          ;have we reached the boundry?
        je      dir_4                   ;yes? then new direction is needed
        cmp     [y_pos],200-16          ;ditto?
        je      dir_2                   ;you get the picture...
        jmp     done_direction          ;passed, remain in current direction
direction2:
        inc     [x_pos]                 ;move down one
        dec     [y_pos]                 ;move left one
        jz      dir_1                   ;boundry?
        cmp     [x_pos],320-64          ;etc, etc, etc...
        je      dir_3
        jmp     done_direction
direction3:
        dec     [x_pos]
        jz      dir_2
        dec     [y_pos]
        jz      dir_4
        jmp     done_direction
direction4:
        dec     [x_pos]
        jz      dir_1
        inc     [y_pos]
        cmp     [y_pos],200-16
        je      dir_3
        jmp     done_direction
;assign new directions, if needed...
dir_1:
        mov     [direction],1
        jmp     done_direction
dir_2:
        mov     [direction],2
        jmp     done_direction
dir_3:
        mov     [direction],3
        jmp     done_direction
dir_4:
        mov     [direction],4
        jmp     done_direction
;-----------------------------------------------------------------------------
direction1b:
        inc     [x_pos2]                ;move down one
        inc     [y_pos2]                ;move right one
        cmp     [x_pos2],320-64         ;have we reached the boundry?
        je      dir_4b                  ;yes? then new direction is needed
        cmp     [y_pos2],200-16         ;ditto?
        je      dir_2b                  ;you get the picture...
        jmp     done_direction2         ;passed, remain in current direction
direction2b:
        inc     [x_pos2]                ;move down one
        dec     [y_pos2]                ;move left one
        jz      dir_1b                  ;boundry?
        cmp     [x_pos2],320-64         ;etc, etc, etc...
        je      dir_3b
        jmp     done_direction2
direction3b:
        dec     [x_pos2]
        jz      dir_2b
        dec     [y_pos2]
        jz      dir_4b
        jmp     done_direction2
direction4b:
        dec     [x_pos2]
        jz      dir_1b
        inc     [y_pos2]
        cmp     [y_pos2],200-16
        je      dir_3b
        jmp     done_direction2
;assign new directions, if needed...
dir_1b:
        mov     [directionb],1
        jmp     done_direction2
dir_2b:
        mov     [directionb],2
        jmp     done_direction2
dir_3b:
        mov     [directionb],3
        jmp     done_direction2
dir_4b:
        mov     [directionb],4
        jmp     done_direction2
;---------------------------------------------------------------------------
direction1c:
        inc     [x_pos3]                ;move down one
        inc     [y_pos3]                ;move right one
        cmp     [x_pos3],320-64         ;have we reached the boundry?
        je      dir_4c                  ;yes? then new direction is needed
        cmp     [y_pos3],200-16         ;ditto?
        je      dir_2c                  ;you get the picture...
        jmp     done_direction3         ;passed, remain in current direction
direction2c:
        inc     [x_pos3]                ;move down one
        dec     [y_pos3]                ;move left one
        jz      dir_1c                  ;boundry?
        cmp     [x_pos3],320-64         ;etc, etc, etc...
        je      dir_3c
        jmp     done_direction3
direction3c:
        dec     [x_pos3]
        jz      dir_2c
        dec     [y_pos3]
        jz      dir_4c
        jmp     done_direction3
direction4c:
        dec     [x_pos3]
        jz      dir_1c
        inc     [y_pos3]
        cmp     [y_pos3],200-16
        je      dir_3c
        jmp     done_direction3
;assign new directions, if needed...
dir_1c:
        mov     [directionc],1
        jmp     done_direction3
dir_2c:
        mov     [directionc],2
        jmp     done_direction3
dir_3c:
        mov     [directionc],3
        jmp     done_direction3
dir_4c:
        mov     [directionc],4
        jmp     done_direction3
;----------------------------------------------------------------------------
direction1d:
        inc     [x_pos4]                ;move down one
        inc     [y_pos4]                ;move right one
        cmp     [x_pos4],320-64         ;have we reached the boundry?
        je      dir_4d                  ;yes? then new direction is needed
        cmp     [y_pos4],200-16         ;ditto?
        je      dir_2d                  ;you get the picture...
        jmp     done_direction4         ;passed, remain in current direction
direction2d:
        inc     [x_pos4]                ;move down one
        dec     [y_pos4]                ;move left one
        jz      dir_1d                  ;boundry?
        cmp     [x_pos3],320-64         ;etc, etc, etc...
        je      dir_3d
        jmp     done_direction4
direction3d:
        dec     [x_pos4]
        jz      dir_2d
        dec     [y_pos4]
        jz      dir_4d
        jmp     done_direction4
direction4d:
        dec     [x_pos4]
        jz      dir_1d
        inc     [y_pos4]
        cmp     [y_pos4],200-16
        je      dir_3d
        jmp     done_direction4
;assign new directions, if needed...
dir_1d:
        mov     [directiond],1
        jmp     done_direction4
dir_2d:
        mov     [directiond],2
        jmp     done_direction4
dir_3d:
        mov     [directiond],3
        jmp     done_direction4
dir_4d:
        mov     [directiond],4
        jmp     done_direction4
;==============================================================================
;we have finished messing with the direction, rotate palette, then move
done_direction:
        jmp     check_direction2
done_direction2:
        jmp     check_direction3
done_direction3:
        jmp     check_direction4
done_direction4:
        call    rotpal
        mov     si,offset pal+6         ;why 6?  skip colors 0 & 1
        call    setpal

        mov     si,0                    ;reset to start of letter A
        mov     ax,[y_pos]              ;linear location = 320*y_pos + x_pos
        mov     bx,320
        mul     bx
        add     ax,[x_pos]
        mov     di,ax
        mov     [a_length],16

;in the future, i will use the quicker "out" with 60h, looking for ESC only...
        mov     ah,1                    ;ROM-BIOS Service 01h (key ready?)
        int     16h                     ;perform interrupt (keyboard services)
        jnz     keypressed              ;keywait is >127 bytes away... must
        jmp     keywait                 ;  unconditionally jump
keypressed:
        xor     ah,ah                   ;ROM-BIOS Service 00k (read key)
        int     16h                     ;perform interrupt (keyboard services)

        call    fadeout

;clear the screen, reset mode to text 80x25x16
        xor     ah,ah                   ;ROM-BIOS Service 00h (set mode)
        mov     al,3                    ;mode 3 = text 80x25x16
        int     10h                     ;perform interrupt (video services)

        mov     dx,offset credit
        mov     ah,9
        int     21h

        mov     ah,04Ch                 ;DOS Sub-routine 4Ch (DOS exit program)
        int     21h                     ;perform interrupt

setpal  PROC    near
        mov     cx,768-6                ;skip first two colors, done manually
        mov     al,0                    ;0=set palette
setcx:  mov     dx,3C8h                 ;VGA port
        out     dx,al
        inc     dx                      ;VGA port, palette data
        ;cld
        out     dx,al                   ;color #0=0,0,0
        out     dx,al
        out     dx,al
        out     dx,al                   ;color #1=0,89,55 (bluish color)
        mov     al,89
        out     dx,al
        mov     al,55
        out     dx,al
        rep     outsb                   ;send the rest of the color definitions
        ret
setpal  ENDP

rotpal  PROC    near
;first, save the first color into temp...
        mov     bx,3
        mov     cx,3
loopone:mov     al,[bx+byte ptr pal]
        mov     [temp+bx-3],al
        inc     bx
        loop    loopone
;now, rotate the rest, covering up the first...
        mov     cx,768-6
        mov     bx,6
again:  mov     al,[bx+byte ptr pal]
        mov     [bx+byte ptr pal-3],al
        inc     bx
        loop    again
;last, restore the saved color to the last position in the palette...
        mov     bx,768-3
        mov     cx,3
looptwo:mov     al,[bx+temp-765]
        mov     [bx+byte ptr pal],al
        inc     bx
        loop    looptwo
        ret
rotpal  ENDP

;-----------------------------------------------------------------------
fadeout PROC
        mov   cx,64
onecycle:
        mov     dx,3DAh
wait_:  in      al,dx
        test    al,08h
        jz      wait_
retr_:  in      al,dx
        test    al,08h
        jnz     retr_

        mov   dx,03C7h
        xor   al,al
        out   dx,al
        inc   dx
        inc   dx
        xor   bx,bx
readloop:
        in    al,dx
        mov   byte ptr [pal]+bx,al
        inc   bx
        cmp   bx,256*3
        jl    readloop

        xor   bx,bx
decloop:
        cmp   byte ptr [pal]+bx,0
        je    continue
        dec   byte ptr [pal]+bx

continue:
        inc   bx
        cmp   bx,256*3
        jl    decloop

        mov     dx,3DAh
wait2:  in      al,dx
        test    al,08h
        jz      wait2
retr2:  in      al,dx
        test    al,08h
        jnz     retr2

        mov   dx,03C8h
        mov   al,0
        out   dx,al
        inc   dx
        mov   si,offset pal
        cld
        push  cx
        mov   cx,256*3
        rep   outsb
        pop   cx

        loop  onecycle
        ret
ENDP    fadeout

palarr:
;REMEMBER: every color has a RED value, a GREEN value, and a BLUE value...
;  --==//>> 256 colorZ * 3 bytes per color (R,G,& B) = 768 bytes <<\\==--
;   R  G  B    R  G  B    R  G  B    R  G  B...
db  0, 0, 0,   0,89,55,   0,89,55,   0,80,49,   0,71,43,   0, 6,36,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0

END