//ਬ   䥪: Bump
//ᢥ饭  । 

#include <mem.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>

char screen[64000];
char bump[64000];
char pics[64000];
char light[16384];

void setgrmode(char x);
void setrgbpalette(char color,char r,char g,char b);
void setcolortable();
void draw();
void draw_light();
void copyvirtualscreen();
void init_bump_table();
void init_light_table();
void init_mouse();

void main()
{
        setgrmode(0x13);
        init_bump_table();
        init_light_table();
        setcolortable();
        init_mouse();
        while(!kbhit())
        {
                draw_light();
                draw();
                copyvirtualscreen();
        }
        getch();
        setgrmode(0x3);
}

void setgrmode(char x)
{
        _asm
        {
                xor eax,eax
                mov al,x
                int 10h
        }
}

void setrgbpalette(char color, char r, char g, char b)
{
        _asm
        {
                mov dx,0x3C8
                mov al,color
                out dx,al
                inc dx
                mov al,r
                out dx,al
                mov al,g
                out dx,al
                mov al,b
                out dx,al
        }
}

void setcolortable()
{
        for(long n=0;n<64;n++)
                setrgbpalette(n,n,n,n);
}

void init_bump_table()
{
        FILE *in;
        in=fopen("bump.raw","rb");
        for(long k=0;k<64000;k++)
                bump[k]=fgetc(in);
        fclose(in);
}

void init_light_table()
{
        long ptr=0;
        long color;
        for(long y=-64;y<64;y++)
                for(long x=-64;x<64;x++)
                {
                        color=63*cos(sqrt(x*x+y*y)/37);
                        if(color<0) color=0;
                        light[ptr++]=color;
                }
}

void init_mouse()
{
        _asm
        {
                mov eax,0x7
                mov ecx,0x0
                mov edx,0xC0
                int 33h
                mov eax,0x8
                mov ecx,0x0
                mov edx,0x48
                int 33h
                mov eax,0x4
                mov ecx,0x60
                mov edx,0x24
                int 33h
        }
}

void draw_light()
{
        long mx,my;
        long scr=0;
        memset(pics,0,64000);
        _asm
        {
                xor ecx,ecx
                xor edx,edx
                mov eax,0x3
                int 0x33
                mov mx,ecx
                mov my,edx
        }
        for(long y=my;y<my+128;y++)
                for(long x=mx;x<mx+128;x++)
                        pics[x+(y<<6)+(y<<8)]=light[scr++];
}

void draw()
{
        long scr=321;
        long dx,dy;
        for(long y=1;y<199;y++)
        {
                for(long x=1;x<319;x++)
                {
                        dx=((bump[scr+1]-bump[scr-1]))+x;
                        dy=((bump[scr+320]-bump[scr-320]))+y;
                        if(dx<0) dx=0;
                        if(dx>319) dx=319;
                        if(dy<0) dy=0;
                        if(dy>199) dy=199;
                        screen[scr]=pics[dx+(dy<<6)+(dy<<8)];
                        scr++;
                }
                scr+=2;
        }
}

void copyvirtualscreen()
{
        _asm
        {
                mov dx,3DAh
        a:in al,dx
                test al,8
                jnz a
                mov dx,3DAh
        b:in al,dx
                test al,8
                jz b
        }
        memcpy((char*)0xA0000,screen,64000);
}