//ਬ   Flat Shading
#include <conio.h>
#include "3d_tutor.h"

long normals[nf3][3];
long promnormals[nf3][3];

void initnormals();
void rotatenormals(char x,char y,char z);
void drawflatfaces();
void drawflatface(long n);

void main()
{
        char n=0;
        initobj();
        initnormals();
        setsincostable();
        setgrmode(0x13);
        setcolortable();
        while(!kbhit())
        {
                clearvirtualscreen();
                rotate(n,n,n);
                rotatenormals(n,n,n);
                drawflatfaces();
                copyvirtualscreen();
                n++;
        }
        getch();
        setgrmode(0x3);
}

void initnormals()
{
        long r;
        for(long k=0;k<nf3;k+=3)
        {
                normals[k][0]=((truevertex[facesv3[k][2]][1]-truevertex[facesv3[k][1]][1])*
                               (truevertex[facesv3[k][1]][2]-truevertex[facesv3[k][0]][2])-
                               (truevertex[facesv3[k][2]][2]-truevertex[facesv3[k][1]][2])*
                               (truevertex[facesv3[k][1]][1]-truevertex[facesv3[k][0]][1]))*256;
                normals[k][1]=((truevertex[facesv3[k][2]][2]-truevertex[facesv3[k][1]][2])*
                               (truevertex[facesv3[k][1]][0]-truevertex[facesv3[k][0]][0])-
                               (truevertex[facesv3[k][2]][0]-truevertex[facesv3[k][1]][0])*
                               (truevertex[facesv3[k][1]][2]-truevertex[facesv3[k][0]][2]))*256;
                normals[k][2]=((truevertex[facesv3[k][2]][0]-truevertex[facesv3[k][1]][0])*
                               (truevertex[facesv3[k][1]][1]-truevertex[facesv3[k][0]][1])-
                               (truevertex[facesv3[k][2]][1]-truevertex[facesv3[k][1]][1])*
                               (truevertex[facesv3[k][1]][0]-truevertex[facesv3[k][0]][0]))*256;
                r=sqrt((float)normals[k][0]*normals[k][0]+
                       (float)normals[k][1]*normals[k][1]+
                       (float)normals[k][2]*normals[k][2]);
                normals[k][0]=normals[k+1][0]=normals[k+2][0]=(normals[k][0]*63)/r;
                normals[k][1]=normals[k+1][1]=normals[k+2][1]=(normals[k][1]*63)/r;
                normals[k][2]=normals[k+1][2]=normals[k+2][2]=(normals[k][2]*63)/r;
        }
}

void drawflatfaces()
{
        for(long n=0;n<nf3;n++)
                drawflatface(n);
}

void drawflatface(long n)
{
        if(((promvertex[facesv3[n][2]][0]-promvertex[facesv3[n][1]][0])
           *(promvertex[facesv3[n][1]][1]-promvertex[facesv3[n][0]][1])
           -(promvertex[facesv3[n][2]][1]-promvertex[facesv3[n][1]][1])
           *(promvertex[facesv3[n][1]][0]-promvertex[facesv3[n][0]][0]))>=0)
                return;

        long color=promnormals[n][2];

        long x0=promvertex[facesv3[n][0]][0];
        long x1=promvertex[facesv3[n][1]][0];
        long x2=promvertex[facesv3[n][2]][0];
        long y0=promvertex[facesv3[n][0]][1]>>8;
        long y1=promvertex[facesv3[n][1]][1]>>8;
        long y2=promvertex[facesv3[n][2]][1]>>8;

        long minx,maxx,pminx,pmaxx,miny,midy,maxy,d0,d1,d2,li1,li2,ri1,ri2;
        long x,y,z,dz,k;

        k=y1-y0;
        if(k<0) k=-k;
        if(k==0) d0=0; else d0=(x0-x1)/k;
        k=y2-y1;
        if(k<0) k=-k;
        if(k==0) d1=0; else d1=(x1-x2)/k;
        k=y0-y2;
        if(k<0) k=-k;
        if(k==0) d2=0; else d2=(x2-x0)/k;

        if(y0>y1)
        {
                if(y0>y2)
                {
                        maxy=y0;
                        minx=x0;
                        maxx=x0;
                        if(y1>y2)
                        {
                                midy=y1;
                                miny=y2;
                                li1=d0;
                                li2=d1;
                                ri1=d2;
                                ri2=d2;
                        }
                        else
                        {
                                midy=y2;
                                miny=y1;
                                li1=d0;
                                li2=d0;
                                ri1=d2;
                                ri2=d1;
                        }
                }
                else
                {
                        maxy=y2;
                        midy=y0;
                        miny=y1;
                        li1=d2;
                        li2=d0;
                        ri1=d1;
                        ri2=d1;
                        minx=x2;
                        maxx=x2;
                        if(y2==y0) minx=x0;
                }
        }
        else
        {
                if(y1>y2)
                {
                        maxy=y1;
                        minx=x1;
                        maxx=x1;
                        if(y0>y2)
                        {
                                midy=y0;
                                miny=y2;
                                li1=d1;
                                li2=d1;
                                ri1=d0;
                                ri2=d2;
                                if(y1==y0) maxx=x0;
                        }
                        else
                        {
                                midy=y2;
                                miny=y0;
                                li1=d1;
                                li2=d2;
                                ri1=d0;
                                ri2=d0;
                        }
                }
                else
                {
                        maxy=y2;
                        midy=y1;
                        miny=y0;
                        li1=d2;
                        li2=d2;
                        ri1=d1;
                        ri2=d0;
                        minx=x2;
                        maxx=x2;
                        if(y2==y1) maxx=x1;
                }
        }
        for(y=maxy;y>miny;y--)
        {
                pminx=minx>>8;
                pmaxx=maxx>>8;
                k=pminx+(y<<6)+(y<<8);
                for(x=pminx;x<pmaxx;x++)
                        screen[k++]=color;
                if(y==midy)
                {
                        li1=li2;
                        ri1=ri2;
                }
                minx=minx-li1-1;
                maxx=maxx+ri1+1;
        }
}

void rotatenormals(char x,char y,char z)
{
        long sinx=sintable[x];
        long siny=sintable[y];
        long sinz=sintable[z];
        long cosx=costable[x];
        long cosy=costable[y];
        long cosz=costable[z];
        long px,py,pz,jx,kx,iy;
        for(long k=0;k<36;k++)
        {
                px=normals[k][0];
                py=normals[k][1];
                pz=normals[k][2];
                jx=(py*cosx+pz*sinx) >> 8;
                kx=(pz*cosx-py*sinx) >> 8;
                iy=(px*cosy-kx*siny) >> 8;
                pz=(kx*cosy+px*siny) >> 8;
                px=(iy*cosz+jx*sinz) >> 8;
                py=(jx*cosz-iy*sinz) >> 8;
                promnormals[k][0]=px;
                promnormals[k][1]=py;
                promnormals[k][2]=pz;
        }
}