#include <math.h>
#include "3d_tutor.inc"

const double PI = 3.141592653587932385;

char screen[64000];

long vertex[nv][3];
long promvertex[nv][3];
long sintable[256],costable[256];

void setgrmode(char x);
void setrgbpalette(char color,char r,char g,char b);
void setcolortable();
void clearvirtualscreen();
void copyvirtualscreen();
void setsincostable();
void initobj();
void rotate(char x,char y,char z);

void setgrmode(char x)
{
	_asm
	{
		xor eax,eax
		mov al,x
		int 10h
	}
}

void setrgbpalette(char color, char r, char g, char b)
{
	_asm
	{
		mov dx,0x3C8
		mov al,color
		out dx,al
		inc dx
		mov al,r
		out dx,al
		mov al,g
		out dx,al
		mov al,b
		out dx,al
	}
}

void setcolortable()
{
	for(long n=0;n<64;n++)
		setrgbpalette(n,n,n,n);
}

void clearvirtualscreen()
{
	_asm
	{
		cld
		mov ecx,16000
		mov edi,offset screen
		mov eax,0x00000000
		rep stosd
	}
}

void copyvirtualscreen()
{
	_asm
	{
		mov dx,3DAh
	a:in al,dx
		test al,8
		jnz a
		mov dx,3DAh
	b:in al,dx
		test al,8
		jz b
		cld
		mov edi,0xA0000
		mov esi,offset screen
		mov ecx,16000
		rep movsd
	}
}

void setsincostable()
{
	for(long k=0;k<256;k++)
	{
		sintable[k]=(sin(k*PI/128)*256);
		costable[k]=(cos(k*PI/128)*256);
	}
}

void initobj()
{
	for(long k=0;k<nv;k++)
	{
		vertex[k][0]=truevertex[k][0]*256;
		vertex[k][1]=truevertex[k][1]*256;
		vertex[k][2]=truevertex[k][2]*256;
	}
}

void rotate(char x,char y,char z)
{
	long sinx=sintable[x];
	long siny=sintable[y];
	long sinz=sintable[z];
	long cosx=costable[x];
	long cosy=costable[y];
	long cosz=costable[z];
	long px,py,pz,jx,kx,iy;
	for(long k=0;k<nv;k++)
	{
		px=vertex[k][0];
		py=vertex[k][1];
		pz=vertex[k][2];
		jx=(py*cosx+pz*sinx) >> 8;
		kx=(pz*cosx-py*sinx) >> 8;
		iy=(px*cosy-kx*siny) >> 8;
		pz=(kx*cosy+px*siny) >> 8;
		px=(iy*cosz+jx*sinz) >> 8;
		py=(jx*cosz-iy*sinz) >> 8;
		promvertex[k][0]=40960+(px<<8)/((pz>>8)+256);
		promvertex[k][1]=25600-0.83*(py<<8)/((pz>>8)+256);
	}
}