//
//  1st example for lzp-style data compression                   red_13 1998
//
//
//  if you use any parts from this code in your programs (i recommend you to
//  improve the algorithm before doing that, though), please credit me. :)
//
//

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <iostream.h>

//
//  some global crap
//

char *hashbuf[0x1000]; 
char *inbuf, *dstbuf; long buflen, bytes_out = 0;

//
//  function to write variable-length codes to output stream
//

static long outcount = 0;
static unsigned long outbuf = 0;

void putcode (unsigned long code, unsigned long csize) {
  outbuf |= (unsigned long) code << (32-csize-outcount);
  outcount += csize;

  while (outcount >= 8) {
    *dstbuf++ = (unsigned char) (outbuf >> 24);
    bytes_out++;
    outbuf <<= 8;
    outcount-=8;
  }
}

//
//  the hashing function
//

inline long hashval (long value) {
  value &= 0xffffff;
  return (long) (((value >> 11) ^ value) & 0xfff);
}

//
//  main
//

void main (long argc, char *argv[]) {
  if (argc < 3) {
    cout << endl << "syntax: lzp <infile> <outfile>" << endl;
    exit(1);
  }

  FILE *qf = fopen(argv[1], "rb");

  if (!qf) {
    cout << "can't open input file." << endl;
    exit(1);
  }

  FILE *zf = fopen(argv[2], "wb");

  if (!zf) {
    cout << "can't create output file." << endl;
    exit(1);
  }

  fseek(qf, 0, SEEK_END);                       // get input file's size
  buflen = ftell(qf);
  fseek(qf, 0, SEEK_SET);

  cout << endl << "compressing" << endl << "   ";

  inbuf = new char [buflen+100];
  dstbuf = new char [buflen*2];                 // make it fit for sure ;)

  memset(hashbuf, 0, 0x1000 * 4);               // initialize hash table

  fread(inbuf, 1, buflen, qf);                  // read input file
  fclose(qf);

  char *string, *hashstr, *inbufb = inbuf, *dstbufb = dstbuf;
  long hash, prebytes, length, buflenb = buflen;

  while (buflen > 0) {
    string = inbuf;
    prebytes = *((long *) (string-3));          // get preceeding 3 bytes
    hash = hashval(prebytes);
    hashstr = hashbuf[hash];
    hashbuf[hash] = string;

    if (!(buflen % 2000)) putch('.');           // waiting rules =)

    if (hashstr) {                              // is it a match?
      length = 0;

      while (*string == *hashstr) {             // get match length
        string++;
        hashstr++;
        length++;
      }

      if (length) {
        putcode(1, 1);                          // length follows
                                           
        if (length > buflen) length = buflen;   // encode length
        if (length > 63) length = 63;
        putcode(length, 6);
        buflen -= length;
        inbuf += length;

      } else {
        putcode(0, 1);                          // char follows
        putcode(*string, 8);                    // write char
        buflen--;
        inbuf++;
      }

    } else {
      putcode(*string, 8);                      // write char
      buflen--;
      inbuf++;
    }
  }

  putcode(0, 8);                                // flush the buffer
  putcode(0, 8);

  fwrite(dstbufb, 1, bytes_out, zf);            // write compressed stuff
  fwrite(&buflenb, 1, sizeof(long), zf);        // write input buffer size
  fclose(zf);

  cout << endl << endl << "bytes in : " << buflenb << endl;
  cout << "bytes out: " << bytes_out+4 << endl;
  cout << "i/o ratio: " << (bytes_out * 100) / buflenb << "%" << endl;

  delete [] inbufb;
  delete [] dstbufb;
}

//
