enum {an,bn,point};

tvec ttrack::getv(int sel, int n) {
  tkey *kn_1, *kn, *kn1;
  tvec *pn_1, *pn, *pn1;
  int d1, d2;

  kn = (tkey *) track[n];
  pn = (tvec *) kn->d;

  if (sel == point) return *pn;

  if (n == 0) {
    //first key
    kn1 = (tkey *) track[1];
    pn1 = (tvec *) kn1->d;

    if (track.count == 2) {
      //2 keys
      return (*pn1 - *pn)*(1.0 - kn->tension);
    };
    if (mode != 3) {
      //first key, no loop
      return ((*pn1 - *pn)*1.5 - getv(an,1)*0.5)*(1.0 - kn->tension);
    } else {
      //first key, loop
      kn_1= (tkey *) track[track.count-2];
      d1 = ((tkey *) track[track.count-1])->frame - kn_1->frame;
      d2 = kn1->frame - kn->frame;
    };
  } else if (n == track.count-1) {
    //last key
    kn_1 = (tkey *) track[n-1];
    pn_1 = (tvec *) kn_1->d;

    if (track.count == 2) {
      //2 keys
      return (*pn - *pn_1)*(1.0 - kn->tension);
    };
    if (mode != 3) {
      //last key, no loop
      return ((*pn - *pn_1)*1.5 - getv(bn,n-1)*0.5)*(1.0 - kn->tension);
    } else {
      //last key, loop
      kn1 = (tkey *) track[1];
      d1 = kn->frame - kn_1->frame;
      d2 = kn1->frame - ((tkey *) track[0])->frame;
    };
  } else {
    //middle keys
    kn_1= (tkey *) track[n-1];
    kn1 = (tkey *) track[n+1];
    d1 = kn->frame - kn_1->frame;
    d2 = kn1->frame - kn->frame;
  };
  pn_1= (tvec *) kn_1->d;
  pn1 = (tvec *) kn1->d;

  float C;
  float adjust;

  if (sel == an) {
    C = kn->continuity;
    adjust = d1;
  } else {
    C = -kn->continuity;
    adjust = d2;
  };
  adjust /= d1 + d2;
  adjust = 0.5 + (1.0 - fabs(C))*(adjust - 0.5);

  return (   (*pn  - *pn_1) * ((1.0 + kn->bias)*(1.0 - C))
           + (*pn1 - *pn  ) * ((1.0 - kn->bias)*(1.0 + C))
         ) * ((1.0 - kn->tension)*adjust);
};

