  (* 
      S-Fire 
     

       This source code aims to give an illustration of the S-Fire
     implementation.  I've tried to make it as simple as possible so that
     most everyone can understand.  However, I couldn't help descending into
     assembler for the inner loop so I hope you understand it.  It's not
     optimized though so for anyone who's touched assembly, it should be a
     piece of cake.  Actually, if you know the classic fire implementation,
     this source is virtually useless as the important changes are not in the
     inner loop.

     Enjoy.

     Oh, and I purposely made my own procedures instead of using CRT.TPU as
     I hear that the CRT unit is buggy on fast computers.

     -Glen Pawley (Oct 29th, 1998, 4.45pm GMT)

      Comments/replies/suggestions to:
        overload@kemmunet.net.mt <- preferrably this
        glen_pawley@hotmail.com

     
  *)
PROGRAM SFire;

VAR
   FireRate: Word;                      (* Increasing this reduces the amount
                                           of fire and vica versa *)
   PixelNo: Word;                       (* General-purpose Counter *)
   Key: Char;                           (* For the interactive bit *)
   DTime: Word;                         (* Delay *)
   BackBuffer: ARRAY[0..64000] OF Byte; (* Virtual Buffer *)
   Msg: STRING;                         (* Credits message *)
   PastPix: Byte;                       (* You need this variable so that the
                                           fire does not angle to the right *)

PROCEDURE SetMode13;
BEGIN
     ASM
        mov     ax, 13h
        int     10h
     END;
END;

PROCEDURE SetMode3;
BEGIN
     ASM
        mov     ax, 3
        int     10h
     END;
END;

FUNCTION KeyDown: BOOLEAN;
  (* This function returns true if a key is pressed and false if no key is
     pressed.  This works in the same way as Pascal's 'KeyPressed' *)
VAR
   Yes: Byte;
LABEL
     NotPressed;
BEGIN
     ASM
        mov     ah, 0bh
        int     21h
        cmp     al, 0ffh
        jne     NotPressed
        mov     Yes, al
NotPressed:
     END;
     IF (Yes = $ff) THEN KeyDown := TRUE
     ELSE KeyDown := FALSE;
END;

FUNCTION GetKey: Char;
  (* This function reads a key from the keyboard and returns it.  It is the
     equivalent of Pascal's 'ReadKey' *)
VAR
   Character: Char;
BEGIN
     ASM
        mov     ah, 07
        int     21h
        mov     Character, al
     END;
     GetKey := Character;
END;

PROCEDURE SetColor(ColIndex, R,G,B: Byte);
  (* This procedure sets a color in the palette with the given attributes *)
BEGIN
     ASM
        mov     dx, 03c8h
        mov     al, ColIndex
        out     dx, al
        mov     dx, 03c9h
        mov     al, R
        out     dx, al
        mov     al, G
        out     dx, al
        mov     al, B
        out     dx, al
     END;
END;

PROCEDURE SetFirePal;
  (* This procedure sets the palette as required for the s-fire implementation *)
VAR
   ColNo: Integer;
BEGIN
     SetColor(0,0,0,0);
     FOR ColNo := 1 TO 31 DO
         SetColor(ColNo,63,63,63);
     FOR ColNo := 0 TO 31 DO
         SetColor(ColNo+32,63,63,(31-Colno)*2);
     FOR ColNo := 0 TO 31 DO
         SetColor(ColNo+64,63,(31-Colno)*2,0);
     FOR ColNo := 0 TO 31 DO
         SetColor(ColNo+96,(31-Colno)*2,0,0);
     FOR ColNo := 128 TO 255 DO
         SetColor(ColNo,0,0,0);
END;

PROCEDURE Delay(NTimes: Integer);
  (* My version of a Delay command *)
LABEL
     NextDelay,MainDelay;
BEGIN
     ASM
        mov     cx, NTimes
NextDelay:
        push    cx
        mov     cx, 32767
MainDelay:
        loop    MainDelay
        pop     cx
        loop    NextDelay
     END;
END;

PROCEDURE FireBuffer;
  (* The blurring algorithm is the same you would use for the classic fire's
     I am using one here which as a formula would look like:

     ([A]*2 + [A-1] + [A+1] + [A+320]*4)/8 where A is the location of the
                                           current pixel *)
LABEL
     Nextpixel,NoDecPix;
BEGIN
     ASM
        mov     ax, SEG @Data
        mov     ds, ax
        mov     di, offset BackBuffer
        inc     di
        mov     bl, 255
        mov     PastPix, bl
        mov     bx, 1
NextPixel:
        mov     al, ds:[di]
        xor     ah, ah
        mov     cx, ax
        shl     cx, 1
        mov     al, PastPix
        add     cx, ax
        mov     al, ds:[di+1]
        add     cx, ax
        mov     al, ds:[di+320]
        shl     ax, 2
        add     cx, ax
        shr     cx, 3
        jz      NoDecPix
        dec     cl
NoDecPix:
        mov     ds:[di], cl
        mov     PastPix, cl
        inc     di
        inc     bx
        cmp     bx, 198*320+320
        jb     NextPixel
     END;
END;

PROCEDURE Display(TextString: String);
  (* This procedure is the equivalent of a Write Pascal command.  I coded it
     myself beacuse I am working in mode 13h *)
VAR
   Counter: Integer;
   Character: Char;
BEGIN
     FOR Counter := 1 TO Length(TextString) DO
     BEGIN
          Character := TextString[Counter];
          ASM
             mov     ah, 02             (* I suppose I could use function 9 *)
             mov     dl, Character      (* but I can't be bothered.         *)
             int     21h
          END;
     END;
END;

PROCEDURE WaitRetrace;
LABEL
  l1, l2;
BEGIN
     ASM
        mov     dx,3DAh
l1:
        in      al,dx
        and     al,08h
        jnz     l1
l2:
        in      al,dx
        and     al,08h
        jz      l2
    END;
END;

BEGIN
     PastPix := 255;
     WriteLn;
     WriteLn('S-Fire - Coded by Glen Pawley');
     WriteLn;
     WriteLn('You can interact with this demo by pressing the following keys:');
     WriteLn;
     WriteLn('  -   : Decrease Delay (Slow computer owners - Sorry! Unoptimized Code!)');
     WriteLn('  +   : Increase Delay (For fast video cards)');
     WriteLn('  [   : Decrease Fire');
     WriteLn('  ]   : Increase Fire');
     WriteLn('  Esc : Quit');
     REPEAT UNTIL KeyDown;
     DTime := 1;
     FireRate := 1024;
     SetMode13;
     Msg := CHR(10)+CHR(10)+CHR(10)+CHR(10)+
            CHR(10)+CHR(10)+CHR(10)+CHR(10)+
            CHR(10)+CHR(10)+CHR(10)+CHR(10)+
            CHR(10)+CHR(10)+CHR(10)+CHR(10)+
            CHR(10)+CHR(10)+CHR(10)+CHR(10)+
            CHR(10)+CHR(10)+CHR(10)+CHR(10)+CHR(13);
     Display(Msg);
     Msg := 'S-Fire - Coded by Glen Pawley';
     Display(Msg);
     SetFirePal;
     FOR PixelNo := 0 TO 63999-320*10 DO
         BackBuffer[PixelNo] := 255;
     REPEAT
           FOR PixelNo := 0 TO FireRate DO
               BackBuffer[Random(320)+Random(199)*320] := 255;
           Delay(DTime);
           WaitRetrace;
           FireBuffer;
           FOR PixelNo := 0 TO 63999-320*10 DO
               Mem[$0a000:PixelNo] := BackBuffer[PixelNo];
           WHILE KeyDown DO
           BEGIN
                Key := GetKey;
                IF (Key = '-') THEN DTime := DTime - 1;
                IF (Key = '=') THEN DTime := DTime + 1;
                IF (Key = '[') THEN FireRate := FireRate + 4;
                IF (Key = ']') THEN FireRate := FireRate - 4;
                IF (FireRate <= 0) THEN FireRate := 1;
                IF (DTime <= 0) THEN DTime := 1;
           END;
     UNTIL Key = CHR(27);
     SetMode3;
     WriteLn(' Greets to fellow coders Shadow, Void, Acid, and Killroy');
     WriteLn;
     WriteLn(' Also a brief mention of the following important friends (no order ok? :) :');
     WriteLn('  Steve, Adam, Alan, Mark, Claudia, PG, Fran (both of you), Trinity,');
     WriteLn('  Lauren, Pete, Alex, Chris, Rozyln, Damien, David, Leonard, Mario, ');
     WriteLn('  Melvin, Mark Azzopardi, Adrian, Andrew, George (send me mail man),');
     WriteLn(' and of course:');
     WriteLn('  Claude, Raphel, Clive, Neville, Michelle, Bobby, Marvin, and Sven');
     WriteLn(' (hope I didn''t forget anybody)');
     WriteLn;
     WriteLn(' Special thanks to James and Jeremy for the intro to coding, and to');
     WriteLn(' my family for everything.');
     WriteLn;
     WriteLn(' See you all in Valhalla, or tomorrow at varsity, whichever comes first!');
END.