;#############################################################################
;#
;# color.asm
;#
;# Purpose:
;#	Misc color conversion functions
;#
;#############################################################################

		.386
		.387
		Ideal
		Jumps
		Include 'settings.inc'
		Model	Tiny,C

		Include	'vector.inc'
		Include 'genmath.inc'
		Include 'color2.inc'
		CodeSeg

;******************************************************************************
;*
;* void ColorFloat2RGB(Vector *A,RGBA *B)
;*
;* Purpose:
;*	Converts between floating point rgb-format and standard 0-255 rgb
;*
;* Arguments:
;*	A - near pointer to vector with rgb from 0.0 - 1.0
;*	B - near pointer to RGBA struct to save in
;*
;* Returns:
;*	RGBA-struct in B
;*
;******************************************************************************
Public		ColorFloat2RGB
Proc		ColorFloat2RGB	uses si di ax cx
		arg	A:ptr Vector,B:ptr RGBA
		local	temp:word

		mov	si,[A]
		mov	di,[B]
		inc	di		; Alpha is first

		fld	[FLOAT_255_0]		; Load 8
		fld	st(0)
		fld	st(0)
		mov	cx,3
@@Loop1:
		fld	[dword si]
		fmul
		fistp	[word temp]
		mov	ax,[temp]
		mov	[di],al
		add	si,4
		inc	di
		loop	@@Loop1

;		fld	[si+Vector.X]		; Load color
;		fmul				; color = color*255.0
;		fistp	[temp]
;		mov	ax,[temp]
;		mov	[di+RGBA.R],al

;		fld	[si+Vector.Y]		; Load color
;		fmul				; color = color*255.0
;		fistp	[temp]
;		mov	ax,[temp]
;		mov	[di+RGBA.G],al

;		fld	[si+Vector.Z]		; Load color
;		fmul				; color = color*255.0
;		fistp	[temp]
;		mov	ax,[temp]
;		mov	[di+RGBA.B],al

		ret
EndP		ColorFloat2RGB

Public		ColorRGB2Float
Proc		ColorRGB2Float	uses ax si di cx
		arg	A:ptr RGBA,B:ptr Vector
		local	temp:word

		mov	si,[A]
		mov	di,[B]
		inc	si			; Alpha is first
		mov	cx,3
		xor	ax,ax
@@Loop1:
		mov	al,[si]
		mov	[temp],ax
		fild	[temp]
		fld	[FLOAT_255_0]
		fdiv
		fstp	[dword di]
		add	di,4
		inc	si
		loop	@@Loop1

;		xor	ax,ax
;		mov	al,[si+RGBA.R]
;		mov	[temp],ax
;		fild	[temp]
;		fld	[FLOAT_255_0]
;		fdiv
;		fstp	[di+Vector.X]
;
;		mov	al,[si+RGBA.G]
;		mov	[temp],ax
;		fild	[temp]
;		fld	[FLOAT_255_0]
;		fdiv
;		fstp	[di+Vector.Y]
;
;		mov	al,[si+RGBA.B]
;		mov	[temp],ax
;		fild	[temp]
;		fld	[FLOAT_255_0]
;		fdiv
;		fstp	[di+Vector.Z]
		ret
EndP		ColorRGB2Float

Public		ColorFloatMulFloat
Proc		ColorFloatMulFloat	uses si di bx
		arg	A:ptr Vector,B:ptr Vector,O:ptr Vector
		mov	si,[A]
		mov	di,[B]
		mov	bx,[O]

		fld	[si+Vector.X]
		fld	[di+Vector.X]
		fmulp
		fstp	[bx+Vector.X]

		fld	[si+Vector.Y]
		fld	[di+Vector.Y]
		fmulp
		fstp	[bx+Vector.Y]

		fld	[si+Vector.Z]
		fld	[di+Vector.Z]
		fmulp
		fstp	[bx+Vector.Z]
		ret
EndP		ColorFloatMulFloat
		DataSeg
		Align 2


		end

