;-------------------------------------------------
; entry16 by st0ne
;
; Uncompress picture and display it
; This part switches to 32 bit protected mode and
; then displays data uncompressed by the 32b part.
;-------------------------------------------------

.model tiny
.386
.code
.startup

	org	0100h

Descr	struc
limit0	db	?
limit1	db	?
base0	db	?
base1	db	?
base2	db	?
flags	db	?
limit2	db	?
base3	db	?
Descr	ends

&	equ	offset

;----------------------------------------

;Init (2)
start:	cli
	push	dx		;used to set descriptor

;DPMI installation check (5)
	mov	ax,1687h
	int	2Fh
	;or	ax,ax	;(DPMI ok ?)
	;jnz	@quit
	;test	bl,01h	;(32b ok ?)
	;jz	@quit

;Switch to protected mode (18)
	push	cs		;prepare return address
	push	& @back
	push	es		;switch routine address
	push	di
	mov	ax,ds		;some free real mode memory for dpmi
	add	ah,10h
	mov	es,ax
	mov	ax,0001h	;32b program
	retf			;'call' es:di
@back:	cli
	;jc	@quit	;(still in real mode)

;Allocate memory block (12)
	mov	ax,0501h
	mov	bx,0040h	;about 4 Mb
	int	31h
	;jc	@quit
	push	bx
	push	cx
	pop	ebp		;linear address of memory

;Allocate LDT descriptors (7)
	xor	ax,ax
	mov	cx,0002h
	int	31h		;allocate 2 descriptors
	;jc	@quit

;Set LDT descriptor for screen (9)
	xchg	bx,ax
	mov	ax,000Ch
	mov	di,& desc	;get screen descriptor
	int	31h
	;jc	@quit

;Set LDT descriptor for code (28)
	add	bx,size Descr
	xor	edx,edx
	pop	dx		;get real mode cs
	add	dx,(& start32-& start+100h)/10h
	shl	edx,4		;build base for 32b code
	sub	ebp,edx		;build base for 32b data
	mov	dword ptr[di+(Descr).base0],edx
	mov	word ptr[di+(Descr).flags],0CFFAh
	int	31h
	;jc	@quit

;Alias LDT descriptor for data (4)
	mov	al,0Ah
	int	31h
	;jc	@quit
	
;Jump into 32b mode (8)
	push	cs		;prepare return from 32b
	push	& @exit
	push	bx		;start address of 32b code
	push	000Ch
	retf			;retf 16b
	
;----------------------------------------

;Show picture from data at ds:6000h (12)
@exit:	mov	ax,gs		;data at ds:si
	sub	ax,size Descr	;screen at es:0000h
	mov	es,ax
	mov	ax,0013h	;mode 13h
	int	10h

;UnSplit & Set palette (20)
	mov	al,01h		;first color already 0,0,0
	mov	dx,03C8h
	out	dx,al
	inc	dx
	mov	cx,02D0h
@pal:	mov	al,[si-3]
	sub	al,0Ah		;col[i]+=col[i-3]-0Ah
	add	[si],al
	outsb			;set 240 colors
	loop	@pal

;UnSplit & Display logo (15)
	mov	di,0CACh	;10*320+44
	mov	al,87h		;145-10
@logo:	mov	cl,0E1h		;225
	rep	movsb
	add	di,+5Fh		;320+44-269
	dec	ax
	jnz	@logo

;UnSplit & Display text (44)
	mov	di,0BF48h
	mov	bx,& text
	mov	ah,09h		;0900h=16*36*4
@text:	add	si,ax		;source
	mov	dx,0024h	;36 lines
@t1:	mov	cl,10h
@t2:	lodsb			;al in {7,0,1,..,6}
	add	al,0EAh
	aam	0F1h		;al in {0,EA,EB,..,F0}
	stosb
	loop	@t2
	add	di,0130h	;320-16
	dec	dx
	jnz	@t1
	sub	di,2CF0h	;320*36-16
	mov	al,cs:[bx]
	inc	bx
	cbw
	shl	ax,6		;9*n*64=16*36*n
	jnz	@text

;Wait for a key & quit to dos (12)
	int	16h
	mov	ax,0003h
	int	10h
@quit:	mov	ax,4C00h
	int	21h

;----------------------------------------

;Data (27)
text	db	09h,-09h,09h			;(T)OO_
	db	-12h,-12h,-09h,-36h,36h		;COOL_
	db	-3Fh,1Bh,-3Fh,3Fh		;FOR_
	db	-24h,09h,-2Dh,12h,-09h,-36h,00h	;SCHOOL$

desc	Descr	<0FFh,0FFh,0,0,0Ah,0F2h,0,0>	;for screen

;----------------------------------------

align 16		;due to tlink code alignment

start32:

end